//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;

namespace MatrixMultiplication
{
	/// <summary>
	/// Podsumowanie dla Matrix.
	/// </summary>
	public abstract class MatrixMultiply
	{
		protected double [,] A;
		protected double [,] B;
		// Wynik
		protected double [,] C;
		public MatrixMultiply()
		{
		}
		public MatrixMultiply(double [,] A, double [,] B)
		{
			if(A.GetLength(0) != B.GetLength(1) ||
			   A.GetLength(1) != B.GetLength(0))
				throw new ArgumentOutOfRangeException("Macierze maj niezgodne wymiary");

			this.A = new double[A.GetLength(0), A.GetLength(1)];
			this.B = new double[B.GetLength(0), B.GetLength(1)];
			for(int i = 0; i < A.GetLength(0); i++)
				for(int j = 0; j < A.GetLength(1); j++)
					this.A[i,j] = A[i,j];

			for(int i = 0; i < B.GetLength(0); i++)
				for(int j = 0; j < B.GetLength(1); j++)
					this.B[i,j] = B[i,j];
			this.C = new double[A.GetLength(0), B.GetLength(1)];
		}
		public abstract double [,] Multiply();
		public double [,] Multiply(double [,] A, double [,] B)
		{
			if(A.GetLength(0) != B.GetLength(1) ||
				A.GetLength(1) != B.GetLength(0))
				throw new ArgumentOutOfRangeException("The two matrixes have incompatible dimensions");

			this.A = new double[A.GetLength(0), A.GetLength(1)];
			this.B = new double[B.GetLength(0), B.GetLength(1)];
			for(int i = 0; i < A.GetLength(0); i++)
				for(int j = 0; j < A.GetLength(1); j++)
					this.A[i,j] = A[i,j];

			for(int i = 0; i < B.GetLength(0); i++)
				for(int j = 0; j < B.GetLength(1); j++)
					this.B[i,j] = B[i,j];
			this.C = new double[A.GetLength(0), B.GetLength(1)];
			return Multiply();
		}
	}
}
